string GetDescription()
{
	return "A random structure script with pretty unpredicatble output.";
}

void GenerateStructure(Song@ song)
{
	song.SetUniqueParts(RndInt(1,4));
	song.SetParts(RndInt(song.GetUniqueParts(), (song.GetUniqueParts()*3)));	
	
	int metrum = RndInt(0,2);

	// constant metrum 4
	if (metrum == 0)
	{
		for (int i = 0; i < song.GetUniqueParts(); i++)
			song.GetUniquePart(i).SetMetrum(4);
	}

	// constant random metrum
	if (metrum == 1)
	{
		int m = RndInt(2,8);
		for (int i = 0; i < song.GetUniqueParts(); i++)
			song.GetUniquePart(i).SetMetrum(m);
	}

	// random metrum
	if (metrum == 2)
	{
		for (int i = 0; i < song.GetUniqueParts(); i++)
			song.GetUniquePart(i).SetMetrum(RndInt(2,8));
	}
	
	int[] trans(3);

	trans[0] = RndInt(0, 11);
	trans[1] = (trans[0] + 5) % 12;
	trans[2] = (trans[1] + 5) % 12;

	for (int i = 0; i < song.GetParts(); i++)
	{
		Part@ p = song.GetPart(i);
		p.SetUniquePart(RndInt(0,song.GetUniqueParts()-1));		
		p.SetTranspose(trans[RndInt(0,2)]);
		p.SetTempoMod(1.0);
		p.SetScale(GetRandomScale());
		p.SetArrHint(RndInt(1,3));
	}
}